---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 9
  claims_with_evidence: 8
  claims_without_evidence: 1
confidence_derived: 0.89
---

# 根拠レポート：155-Cat 保留中タスク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：8 / 9、根拠なし：1
- 優先レビュー（高）
  1. **priorityの取りうる値の列挙**：Priority enumの全値を確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cat.pending_tasks.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestPendingClusterTasksAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行156

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /_cat/pending_tasks | E-01, E-02 行61 | ○ |
| C-02 | リクエストパラメータにformat, local, h, help, s, time, vが存在 | E-01 params | ○ |
| C-03 | 表示カラムはinsertOrder, timeInQueue, priority, sourceの4つ | E-02 行97-101 | ○ |
| C-04 | PendingClusterTasksRequestをクラスタマネージャに発行 | E-02 行76, 82-84 | ○ |
| C-05 | ペンディングタスクが0件の場合は空のレスポンス | E-02 行108 forループ | ○ |
| C-06 | master_timeout非推奨パラメータ対応 | E-01, E-02 行80 | ○ |
| C-07 | localパラメータサポート | E-01, E-02 行81 | ○ |
| C-08 | insertOrderは単調増加のシーケンス番号 | E-02 行110 getInsertOrder() | ○ |
| C-09 | priorityはIMMEDIATE, URGENT, HIGH, NORMAL, LOW, LANGUIDの順 | **根拠なし**（Priority enum未確認） | △ |

## 4) 不足情報（Unknown / Missing）
- Priority enumの定義ファイルを読み込んでおらず、priorityの取りうる値の列挙は推定
  - 候補：`server/src/main/java/org/opensearch/common/Priority.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様の主要部分はソースコードから直接確認済み
- 1: 中リスク - priorityの取りうる値は推定

## 6) レビュアーチェックリスト（最小）
- [ ] 表示カラムの一覧がソースコードのgetTableWithHeader()と一致しているか
- [ ] priorityの取りうる値がPriority enumと一致しているか
- [ ] リクエストパラメータがcat.pending_tasks.jsonの定義と一致しているか
